/*
 * Decompiled with CFR 0.152.
 */
package Cafe;

import Cafe.FrameMain;
import Cafe.secadoAdministrador;
import Tools.GeneralTools;
import Tools.TextAreaRenderer3;
import Tools.TextFieldEditor;
import calendar2.gnu.gui.datepicker.JPanelDatePicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class secadoNueva
extends JFrame {
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private XYLayout xYLayout1 = new XYLayout();
    private XYLayout xYLayout2 = new XYLayout();
    private JPanelDatePicker fechaPartida = new JPanelDatePicker("yyyy/MM/dd");
    private JLabel jLabel2 = new JLabel();
    private JTextField noPartida = new JTextField();
    private JLabel jLabel3 = new JLabel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private Icon guardar;
    private JTable jTable1;
    Vector columns;
    Vector Nombrecolumns;
    TableModel dataModel;
    String idSecado;
    private JButton jButton1;
    private secadoAdministrador parent;
    private boolean bandInicio;

    public secadoNueva(secadoAdministrador parent, String idSecado, String idPartida, String fecha) {
        this.guardar = new ImageIcon(this.getClass().getResource(FrameMain.Gt.IMAGEN_GUARDAR));
        this.jTable1 = new JTable();
        this.columns = new Vector();
        this.Nombrecolumns = new Vector();
        this.dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 9;
            }

            @Override
            public int getRowCount() {
                return secadoNueva.this.columns.size() / 9;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return secadoNueva.this.columns.elementAt(9 * (row + 1 - 1) + col);
            }

            @Override
            public String getColumnName(int column) {
                return secadoNueva.this.Nombrecolumns.elementAt(column).toString();
            }

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 3 || col == 6;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (column == 3) {
                    if (!FrameMain.Gt.IsCurrency(aValue.toString())) {
                        FrameMain.Ap.GetMessage("El valor resultante no es valido.", 1, "");
                        return;
                    }
                    secadoNueva.this.columns.setElementAt(FrameMain.Gt.FormatValue("#.##", Double.parseDouble(aValue.toString().replaceAll(",", ""))), row * 9 + column);
                }
                if (column == 6) {
                    if (!FrameMain.Gt.IsNumber(aValue.toString())) {
                        FrameMain.Ap.GetMessage("La bodega no es valida.", 1, "");
                        return;
                    }
                    secadoNueva.this.columns.setElementAt(aValue, row * 9 + column);
                }
                this.fireTableCellUpdated(row, column);
                secadoNueva.this.calcularRendimiento();
            }
        };
        this.idSecado = "";
        this.jButton1 = new JButton();
        this.bandInicio = true;
        try {
            this.idSecado = idSecado;
            this.parent = parent;
            if (!idSecado.equals("0")) {
                this.noPartida.setText(idPartida);
                this.fechaPartida.setText(fecha);
                this.cargarContenido();
                this.cargarDetalle();
                this.noPartida.setEditable(false);
                this.fechaPartida.setButtonVisible(false);
            } else {
                this.noPartida.setText(idPartida);
                this.fechaPartida.setText(fecha);
                this.cargarContenido();
                this.cargarDetalle();
            }
            this.jbInit();
            this.setIconImage(GeneralTools.iconoFrame);
            this.calcularRendimiento();
            FrameMain.Gt.centerFrame(this);
            if (this.columns.size() > this.jTable1.getModel().getColumnCount()) {
                this.jTable1.setRowSelectionInterval(0, 0);
                this.jTable1.setColumnSelectionInterval(3, 3);
                this.jTable1.editCellAt(0, 3);
                Component c = this.jTable1.getEditorComponent();
                if (c instanceof JTextComponent) {
                    JTextField jt = (JTextField)c;
                    c.requestFocus();
                    jt.setSelectionStart(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(674, 411));
        this.getContentPane().setLayout(null);
        this.setTitle("Nuevo Secado");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                secadoNueva.this.this_windowClosing(e);
            }
        });
        this.jPanel1.setBounds(new Rectangle(5, 5, 655, 35));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder(1));
        this.jPanel1.setLayout(this.xYLayout1);
        this.jPanel2.setBounds(new Rectangle(5, 310, 655, 65));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder(1));
        this.jPanel2.setLayout(this.xYLayout2);
        this.jLabel2.setText("Fecha:");
        this.jLabel2.setFont(new Font("Tahoma", 0, 13));
        this.noPartida.setFont(new Font("Tahoma", 0, 13));
        this.noPartida.setEditable(false);
        this.noPartida.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                secadoNueva.this.noPartida_keyReleased(e);
            }
        });
        this.jLabel3.setText("Partida:");
        this.jLabel3.setFont(new Font("Tahoma", 0, 13));
        this.jScrollPane1.setBounds(new Rectangle(5, 45, 655, 260));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                secadoNueva.this.jTable1_keyReleased(e);
            }
        });
        this.jButton1.setText("Guardar");
        this.jButton1.setFont(new Font("Tahoma", 0, 13));
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.setIcon(this.guardar);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                secadoNueva.this.jButton1_actionPerformed(e);
            }
        });
        this.fechaPartida.setLabelPreferedSize(new Dimension(0, 0));
        this.fechaPartida.setTextFont(new Font("Tahoma", 0, 13));
        this.fechaPartida.setTextFieldEditable(false);
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
        this.getContentPane().add((Component)this.jScrollPane1, null);
        this.jPanel2.add((Component)this.jButton1, new XYConstraints(5, 5, 55, 50));
        this.getContentPane().add((Component)this.jPanel2, null);
        this.getContentPane().add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jLabel3, new XYConstraints(5, 10, 95, 15));
        this.jPanel1.add((Component)this.noPartida, new XYConstraints(60, 5, 85, 20));
        this.jPanel1.add((Component)this.fechaPartida, new XYConstraints(200, 5, 110, 20));
        this.jPanel1.add((Component)this.jLabel2, new XYConstraints(155, 10, 95, 15));
        this.jTable1.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "selectNextColumnCell");
    }

    private void cargarContenido() {
        try {
            Statement stmt = FrameMain.conn.createStatement();
            String sql = "SELECT A.ID_TIPO_CAFE, A.NOMBRE_TIPO_CAFE, A.CONVERSION_SECADO, (SELECT IFNULL(SUM(B.PESO_BENEFICIO),0) FROM CAF_ENTRADAS B  WHERE B.ID_COSECHA = " + FrameMain.idCosecha + " AND B.ID_PARTIDA = " + this.noPartida.getText() + " AND B.ID_TIPO_CAFE = A.ID_TIPO_CAFE) AS CONTENIDO, " + "(SELECT IFNULL(SUM(C.RESULTANTE),0) FROM CAF_SECADO D, CAF_SECADO_DETALLE C WHERE D.ID_SECADO = C.ID_SECADO AND C.ID_TIPO_CAFE = A.ID_TIPO_CAFE AND  " + "D.ID_COSECHA = " + FrameMain.idCosecha + " AND D.ID_PARTIDA = " + this.noPartida.getText() + " AND D.ID_SECADO <> " + this.idSecado + ") AS ACUMULADO " + "FROM CAF_TIPOS_CAFES AS A " + "WHERE A.CLASIFICACION IN ('U','S');";
            System.out.println(sql);
            ResultSet rs = stmt.executeQuery(sql);
            this.columns.removeAllElements();
            this.Nombrecolumns.removeAllElements();
            this.Nombrecolumns.add("Calidad");
            this.Nombrecolumns.add("Oro/Uva");
            this.Nombrecolumns.add("Acumulado");
            this.Nombrecolumns.add("Resultante");
            this.Nombrecolumns.add("Resultante QQ");
            this.Nombrecolumns.add("Rendimiento");
            this.Nombrecolumns.add("Bodega");
            this.Nombrecolumns.add("conversion");
            this.Nombrecolumns.add("idCalidad");
            while (rs.next()) {
                this.columns.add(rs.getString("nombre_tipo_cafe"));
                this.columns.add(FrameMain.Gt.FormatValue("#.##", rs.getDouble("contenido")));
                this.columns.add(FrameMain.Gt.FormatValue("#.##", rs.getDouble("acumulado")));
                this.columns.add("0.00");
                this.columns.add("0.00");
                this.columns.add("0.00");
                this.columns.add("0");
                this.columns.add(rs.getString("CONVERSION_SECADO"));
                this.columns.add(rs.getString("id_tipo_cafe"));
            }
            rs.close();
            stmt.close();
            this.jTable1.setModel(this.dataModel);
            this.jTable1.getColumn(this.jTable1.getColumnName(0)).setPreferredWidth(160);
            this.jTable1.getColumn(this.jTable1.getColumnName(1)).setPreferredWidth(75);
            this.jTable1.getColumn(this.jTable1.getColumnName(2)).setPreferredWidth(75);
            this.jTable1.getColumn(this.jTable1.getColumnName(3)).setPreferredWidth(75);
            this.jTable1.getColumn(this.jTable1.getColumnName(4)).setPreferredWidth(100);
            this.jTable1.getColumn(this.jTable1.getColumnName(5)).setPreferredWidth(75);
            this.jTable1.getColumn(this.jTable1.getColumnName(6)).setPreferredWidth(75);
            this.jTable1.getColumn(this.jTable1.getColumnName(3)).setCellRenderer(new TextAreaRenderer3());
            this.jTable1.getColumn(this.jTable1.getColumnName(3)).setCellEditor(new TextFieldEditor());
            this.jTable1.getColumn(this.jTable1.getColumnName(6)).setCellRenderer(new TextAreaRenderer3());
            this.jTable1.getColumn(this.jTable1.getColumnName(6)).setCellEditor(new TextFieldEditor());
            this.jTable1.setRowHeight(20);
            this.jTable1.setFont(new Font("Tahoma", 0, 13));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            DefaultTableCellRenderer rendererR = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(0);
            rendererR.setHorizontalAlignment(4);
            renderer.setBackground(new Color(224, 223, 227));
            renderer.setFont(new Font("Tahoma", 1, 13));
            renderer.setBorder(this.jTable1.getBorder());
            JTableHeader tj = this.jTable1.getTableHeader();
            tj.setDefaultRenderer(renderer);
            this.jTable1.getColumn(this.jTable1.getColumnName(1)).setCellRenderer(rendererR);
            this.jTable1.getColumn(this.jTable1.getColumnName(2)).setCellRenderer(rendererR);
            this.jTable1.getColumn(this.jTable1.getColumnName(4)).setCellRenderer(rendererR);
            this.jTable1.getColumn(this.jTable1.getColumnName(5)).setCellRenderer(rendererR);
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    private void cargarDetalle() {
        try {
            Statement stmt = FrameMain.conn.createStatement();
            String sql = "SELECT B.FECHA,A.RESULTANTE, A.RESULTANTE_QQ, A.CONVERSION, A.BODEGA, A.ID_TIPO_CAFE FROM CAF_SECADO_DETALLE A, CAF_SECADO B WHERE A.ID_SECADO = B.ID_SECADO AND B.ID_SECADO = " + this.idSecado;
            System.out.println("Detalle:" + sql);
            ResultSet rs = stmt.executeQuery(sql);
            this.Nombrecolumns.removeAllElements();
            this.Nombrecolumns.add("Calidad");
            this.Nombrecolumns.add("Contenido");
            this.Nombrecolumns.add("Acumulado");
            this.Nombrecolumns.add("Resultante");
            this.Nombrecolumns.add("Resultante QQ");
            this.Nombrecolumns.add("Rendimiento");
            this.Nombrecolumns.add("Bodega");
            this.Nombrecolumns.add("conversion");
            this.Nombrecolumns.add("idCalidad");
            String idCafe = "";
            while (rs.next()) {
                this.fechaPartida.setText(rs.getString("fecha"));
                idCafe = rs.getString("id_tipo_cafe");
                for (int i = 0; i < this.columns.size(); i += 9) {
                    if (!this.columns.elementAt(i + 8).equals(idCafe)) continue;
                    this.columns.setElementAt(FrameMain.Gt.FormatValue("#.##", rs.getDouble("resultante")), i + 3);
                    this.columns.setElementAt(FrameMain.Gt.FormatValue("#.##", rs.getDouble("resultante_QQ")), i + 4);
                    this.columns.setElementAt(rs.getString("bodega"), i + 6);
                    this.columns.setElementAt(rs.getString("conversion"), i + 7);
                }
            }
            rs.close();
            stmt.close();
            this.jTable1.setModel(this.dataModel);
            this.jTable1.setRowHeight(20);
            this.jTable1.setFont(new Font("Tahoma", 0, 13));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(0);
            renderer.setBackground(new Color(224, 223, 227));
            renderer.setFont(new Font("Tahoma", 1, 13));
            renderer.setBorder(this.jTable1.getBorder());
            JTableHeader tj = this.jTable1.getTableHeader();
            tj.setDefaultRenderer(renderer);
            this.jTable1.removeColumn(this.jTable1.getColumnModel().getColumn(8));
            this.jTable1.removeColumn(this.jTable1.getColumnModel().getColumn(7));
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    private void calcularRendimiento() {
        double rQQ = 0.0;
        for (int i = 0; i < this.columns.size(); i += 9) {
            rQQ = (Double.parseDouble(this.columns.elementAt(i + 2).toString().replaceAll(",", "")) + Double.parseDouble(this.columns.elementAt(i + 3).toString().replaceAll(",", ""))) / Double.parseDouble(this.columns.elementAt(i + 7).toString().replaceAll(",", ""));
            this.columns.setElementAt(FrameMain.Gt.FormatValue("#.##", rQQ), i + 4);
            if (rQQ > 0.0) {
                this.columns.setElementAt(FrameMain.Gt.FormatValue("#.##", Double.parseDouble(this.columns.elementAt(i + 1).toString().replaceAll(",", "")) / rQQ), i + 5);
                continue;
            }
            this.columns.setElementAt(FrameMain.Gt.FormatValue("#.##", 0.0), i + 5);
        }
    }

    private void noPartida_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.cargarContenido();
            this.cargarDetalle();
            this.calcularRendimiento();
        }
    }

    private void jButton1_actionPerformed(ActionEvent e) {
        try {
            this.jTable1.getCellEditor().stopCellEditing();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.calcularRendimiento();
        if (this.noPartida.getText().length() == 0) {
            FrameMain.Ap.GetMessage("Debe de seleccionar la partida.", 1, "");
            return;
        }
        if (this.fechaPartida.getText().length() == 0) {
            FrameMain.Ap.GetMessage("Debe de seleccionar la fecha de la partida.", 1, "");
            return;
        }
        if (this.validarBodegasCero()) {
            return;
        }
        this.Guardar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Guardar() {
        String sql = "";
        try {
            Statement stmt = FrameMain.conn.createStatement();
            if (this.idSecado.equals("0")) {
                this.idSecado = this.LoadMaxId();
                sql = "insert into caf_secado(id_secado,id_cosecha,id_partida,fecha)values(" + this.idSecado + "," + FrameMain.idCosecha + "," + this.noPartida.getText() + ",'" + this.fechaPartida.getText() + "')";
                stmt.executeUpdate(sql);
            }
            sql = "delete from caf_secado_detalle where id_secado = " + this.idSecado;
            stmt.executeUpdate(sql);
            for (int i = 0; i < this.columns.size(); i += 9) {
                sql = "insert into caf_secado_detalle(id_secado,id_tipo_cafe,resultante,resultante_QQ,conversion,bodega)values(" + this.idSecado + "," + this.columns.elementAt(i + 8) + "," + this.columns.elementAt(i + 3).toString().replaceAll(",", "") + "," + this.columns.elementAt(i + 4).toString().replaceAll(",", "") + "," + "" + this.columns.elementAt(i + 7).toString().replaceAll(",", "") + "," + this.columns.elementAt(i + 6).toString().replaceAll(",", "") + ")";
                stmt.executeUpdate(sql);
            }
            stmt.close();
            this.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String LoadMaxId() {
        try {
            Statement stmt = FrameMain.conn.createStatement();
            String sql = "Select max(id_secado) + 1 as max from caf_secado";
            System.out.println(sql);
            String MaxId = "";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                MaxId = rs.getString("max");
            }
            if (MaxId == null) {
                MaxId = "1";
            }
            if (MaxId.equals("")) {
                MaxId = "1";
            }
            rs.close();
            stmt.close();
            String string = MaxId;
            return string;
        }
        catch (Exception e) {
            System.out.println(e);
            return "0";
        }
    }

    private void this_windowClosing(WindowEvent e) {
        this.parent.LoadTable();
    }

    private void jTable1_keyReleased(KeyEvent e) {
        System.out.println("ingreso: " + e.getKeyCode());
        if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
            int celda = this.jTable1.getSelectedRow() * this.jTable1.getModel().getColumnCount() + this.jTable1.getSelectedColumn();
            int row = 0;
            int col = 0;
            for (int i = celda; i < this.columns.size(); ++i) {
                row = i / this.jTable1.getModel().getColumnCount();
                if (!this.jTable1.isCellEditable(row, col = i - row * this.jTable1.getModel().getColumnCount())) continue;
                this.jTable1.setRowSelectionInterval(row, row);
                this.jTable1.setColumnSelectionInterval(col, col);
                this.jTable1.editCellAt(row, col);
                Component c = this.jTable1.getEditorComponent();
                if (!(c instanceof JTextComponent)) continue;
                JTextField jt = (JTextField)c;
                c.requestFocus();
                jt.setSelectionStart(0);
                i = this.jTable1.getRowCount();
                break;
            }
        }
    }

    public boolean validarBodegasCero() {
        boolean band = false;
        for (int i = 0; i < this.columns.size(); i += this.jTable1.getModel().getColumnCount()) {
            if (!this.columns.elementAt(i + 6).equals("0") || !(Double.parseDouble(this.columns.elementAt(i + 3).toString()) > 0.0)) continue;
            band = true;
            FrameMain.Ap.GetMessage("No se le ha asignado bodega al dato de cafe " + this.columns.elementAt(i), 1, "");
            break;
        }
        return band;
    }
}

