/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class ButtonEditor
extends DefaultCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected int row;
    protected int column;
    protected JTable table;
    protected JButton button;
    protected JPanel panel = new JPanel(new GridBagLayout());
    protected Icon icono;

    public ButtonEditor() {
        super(new JCheckBox());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = column;
        this.table = table;
        this.button = (JButton)value;
        this.button.setFont(new Font("Tahoma", 0, 13));
        if (this.icono != null) {
            this.button.setIcon(this.icono);
        }
        if (this.button.getActionListeners().length == 0) {
            this.button.addActionListener(this);
        }
        return this.button;
    }

    public static TableCellRenderer getRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JButton button = (JButton)value;
                button.setMargin(new Insets(1, 2, 1, 2));
                button.setFont(new Font("Tahoma", 0, 13));
                return button;
            }
        };
    }
}

