/*
 * Decompiled with CFR 0.152.
 */
package calendar2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class JSpinField
extends JPanel
implements CaretListener,
AdjustmentListener,
ActionListener {
    protected JTextField textField;
    protected JScrollBar scrollBar;
    private Color darkGreen = new Color(0, 150, 0);
    private int min = 0;
    private int max = 100;
    private int value = 0;

    public JSpinField() {
        this.setLayout(new BorderLayout());
        this.textField = new JTextField(Integer.toString(this.value));
        this.textField.addCaretListener(this);
        this.textField.addActionListener(this);
        this.add((Component)this.textField, "Center");
        this.scrollBar = new JScrollBar(1, 0, 0, 0, 100);
        this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.scrollBar.setMinimum(this.min);
        this.scrollBar.setMaximum(this.max);
        this.scrollBar.setValue(this.max + this.min - this.value);
        this.scrollBar.setVisibleAmount(0);
        this.scrollBar.addAdjustmentListener(this);
        this.add((Component)this.scrollBar, "East");
    }

    protected void setValue(int i, boolean flag, boolean flag1) {
        int j = this.value;
        this.value = i < this.min ? this.min : (i > this.max ? this.max : i);
        if (flag) {
            this.textField.setText(Integer.toString(this.value));
            this.textField.setForeground(Color.black);
        }
        if (flag1) {
            this.scrollBar.setValue(this.max + this.min - this.value);
        }
        this.firePropertyChange("value", j, this.value);
    }

    public void setValue(int i) {
        this.setValue(i, true, true);
    }

    public int getValue() {
        return this.value;
    }

    public void setMinimum(int i) {
        this.min = i;
        this.scrollBar.setMinimum(this.min);
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMaximum(int i) {
        this.max = i;
        this.scrollBar.setMaximum(this.max);
    }

    public int getMaximum() {
        return this.max;
    }

    @Override
    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.textField != null) {
            this.textField.setForeground(color);
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretevent) {
        block4: {
            try {
                int i = Integer.valueOf(this.textField.getText());
                if (i >= this.min && i <= this.max) {
                    this.textField.setForeground(this.darkGreen);
                    this.setValue(i, false, false);
                } else {
                    this.textField.setForeground(Color.red);
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof NumberFormatException)) break block4;
                this.textField.setForeground(Color.red);
            }
        }
        this.textField.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
        this.setValue(this.max + this.min - adjustmentevent.getValue(), true, false);
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        if (this.textField.getForeground().equals(this.darkGreen)) {
            this.setValue(Integer.valueOf(this.textField.getText()));
        }
    }

    public static void main(String[] args) {
        JFrame jframe = new JFrame("JSpinField");
        jframe.getContentPane().add(new JSpinField());
        jframe.pack();
        jframe.setVisible(true);
    }
}

