/*
 * Decompiled with CFR 0.152.
 */
package calendar2.gnu.gui.datepicker;

import calendar2.com.toedter.calendar.JCalendar;
import calendar2.com.toedter.calendar.JDayChooser;
import calendar2.com.toedter.calendar.JMonthChooser;
import calendar2.com.toedter.calendar.JYearChooser;
import calendar2.gnu.gui.datepicker.JDateTextField;
import calendar2.gnu.gui.datepicker.JDialogCalc;
import calendar2.gnu.gui.datepicker.JPanelDatePicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JDialogDatePicker
extends JDialog {
    JLabel owner;
    JDateTextField out;
    JPanelDatePicker panelPicker;
    JDialogCalc calc;
    private JYearChooser jYearChooser1;
    private JPanel jPanel3;
    private JButton jButtonCalc;
    private JPanel jPanel2;
    private JButton jButtonToday;
    private JButton jButtonOK;
    private JDayChooser jDayChooser1;
    private JPanel jPanel1;
    private JMonthChooser jMonthChooser1;

    public JDialogDatePicker(JPanelDatePicker panelPicker) {
        super(new Frame(), "", true);
        this.initComponents();
        this.panelPicker = panelPicker;
        this.owner = panelPicker.jLabelDateString;
        this.out = panelPicker.textField.getText().length() == 0 ? panelPicker.textFieldNew : panelPicker.textField;
        this.setupComponents();
    }

    public JDialogDatePicker(JDateTextField dateField) {
        this.initComponents();
        this.panelPicker = null;
        this.out = dateField.getText().length() == 0 ? dateField : this.panelPicker.textField;
        this.setupComponents();
    }

    private void setupComponents() {
        this.calc = new JDialogCalc((Dialog)this, true);
        this.jPanel1.remove(this.jDayChooser1);
        this.jDayChooser1 = new JDayChooser(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button = (JButton)e.getSource();
                String buttonText = button.getText();
                int day = new Integer(buttonText);
                this.setDay(day);
                JDialogDatePicker.this.closeDialog(null);
            }

            @Override
            public void focusGained(FocusEvent e) {
                JButton button = (JButton)e.getSource();
                String buttonText = button.getText();
                int day = new Integer(buttonText);
                this.setDay(day);
            }
        };
        this.jMonthChooser1.setDayChooser(this.jDayChooser1);
        this.jYearChooser1.setDayChooser(this.jDayChooser1);
        this.jPanel1.add((Component)this.jDayChooser1, "Center");
        try {
            this.out.setText("");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getName(), 0);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jDayChooser1 = new JDayChooser();
        this.jPanel3 = new JPanel();
        this.jMonthChooser1 = new JMonthChooser();
        this.jYearChooser1 = new JYearChooser();
        this.jPanel2 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCalc = new JButton();
        this.jButtonToday = new JButton();
        this.setTitle("TIS - SELECT DATE");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JDialogDatePicker.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.jDayChooser1, "Center");
        this.jPanel3.setLayout(new GridLayout(1, 0));
        this.jMonthChooser1.setFont(new Font("Dialog", 0, 10));
        this.jPanel3.add(this.jMonthChooser1);
        this.jPanel3.add(this.jYearChooser1);
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jButtonOK.setMnemonic('O');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogDatePicker.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonOK);
        this.jButtonCalc.setMnemonic('C');
        this.jButtonCalc.setText("Calculate");
        this.jButtonCalc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogDatePicker.this.jButtonCalcActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonCalc);
        this.jButtonToday.setMnemonic('T');
        this.jButtonToday.setText("Today");
        this.jButtonToday.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogDatePicker.this.jButtonTodayActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonToday);
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void jButtonTodayActionPerformed(ActionEvent evt) {
        try {
            this.setCalendar(Calendar.getInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButtonCalcActionPerformed(ActionEvent evt) {
        this.calc.show();
        int val = this.calc.getValue();
        int field = 0;
        try {
            if (this.calc.isDay()) {
                field = 0;
            } else if (this.calc.isMonth()) {
                field = 3;
            } else if (this.calc.isYear()) {
                field = 6;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.calc.isIncrease()) {
            this.increaseDate(field, val);
        } else {
            this.decreaseDate(field, val);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        try {
            this.panelPicker.textField.setDate(this.getCalendar().getTime());
            if (this.panelPicker != null) {
                this.panelPicker.updateLabelText();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getName(), 0);
        }
        this.setVisible(false);
    }

    public void setMonth(int month) {
        this.jMonthChooser1.setMonth(month);
    }

    public void setDay(int day) {
        this.jDayChooser1.setDay(day);
    }

    public void setYear(int year) {
        this.jYearChooser1.setYear(year);
    }

    public int getMonth() throws Exception {
        return this.out.getCalendar().get(2);
    }

    public int getDay() throws Exception {
        return this.out.getCalendar().get(5);
    }

    public int getYear() throws Exception {
        return this.out.getCalendar().get(1);
    }

    public Date getDate() {
        return this.getCalendar().getTime();
    }

    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, this.jMonthChooser1.getMonth());
        calendar.set(5, this.jDayChooser1.getDay());
        calendar.set(1, this.jYearChooser1.getYear());
        return calendar;
    }

    public void setCalendar(Calendar calendar) {
        Calendar _tmp = calendar;
        this.setDay(calendar.get(5));
        Calendar _tmp1 = calendar;
        this.setMonth(calendar.get(2));
        Calendar _tmp2 = calendar;
        this.setYear(calendar.get(1));
    }

    public void setDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.setCalendar(calendar);
    }

    protected void increaseDate(int caretPosition, int val) {
        try {
            Calendar calendar = this.getCalendar();
            JCalendar cal = new JCalendar();
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            if (caretPosition >= 0 && caretPosition <= 2) {
                calendar.set(5, day + val);
            } else if (caretPosition >= 2 && caretPosition <= 5) {
                calendar.set(2, month + val);
            } else if (caretPosition >= 5) {
                calendar.set(1, year + val);
            }
            this.setCalendar(calendar);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void decreaseDate(int caretPosition, int val) {
        try {
            Calendar calendar = this.getCalendar();
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            if (caretPosition >= 0 && caretPosition <= 2) {
                calendar.set(5, day - val);
            } else if (caretPosition >= 2 && caretPosition <= 5) {
                calendar.set(2, month - val);
            } else if (caretPosition >= 5) {
                calendar.set(1, year - val);
            }
            this.setCalendar(calendar);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

