/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.util.JRCloneUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRDesignXyzDataset
extends JRDesignChartDataset
implements JRXyzDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_XYZ_SERIES = "xyzSeries";
    private List<JRXyzSeries> xyzSeriesList = new ArrayList<JRXyzSeries>();

    public JRDesignXyzDataset(JRChartDataset dataset) {
        super(dataset);
    }

    @Override
    public JRXyzSeries[] getSeries() {
        JRXyzSeries[] xyzSeriesArray = new JRXyzSeries[this.xyzSeriesList.size()];
        this.xyzSeriesList.toArray(xyzSeriesArray);
        return xyzSeriesArray;
    }

    public List<JRXyzSeries> getSeriesList() {
        return this.xyzSeriesList;
    }

    public void addXyzSeries(JRXyzSeries xyzSeries) {
        this.xyzSeriesList.add(xyzSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_XYZ_SERIES, xyzSeries, this.xyzSeriesList.size() - 1);
    }

    public void addXyzSeries(int index, JRXyzSeries xyzSeries) {
        this.xyzSeriesList.add(index, xyzSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_XYZ_SERIES, xyzSeries, index);
    }

    public JRXyzSeries removeXyzSeries(JRXyzSeries xyzSeries) {
        int idx;
        if (xyzSeries != null && (idx = this.xyzSeriesList.indexOf(xyzSeries)) >= 0) {
            this.xyzSeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_XYZ_SERIES, xyzSeries, idx);
        }
        return xyzSeries;
    }

    @Override
    public byte getDatasetType() {
        return 4;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    @Override
    public Object clone() {
        JRDesignXyzDataset clone = (JRDesignXyzDataset)super.clone();
        clone.xyzSeriesList = JRCloneUtils.cloneList(this.xyzSeriesList);
        return clone;
    }
}

