/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.ElementEvaluationAction;
import net.sf.jasperreports.engine.fill.ElementEvaluationVirtualizationListener;
import net.sf.jasperreports.engine.fill.EvaluationBoundAction;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillReportTemplate;
import net.sf.jasperreports.engine.fill.JRFillSection;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.SavePoint;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.LinkedMap;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JRBaseFiller
implements JRDefaultStyleProvider {
    private static final Log log = LogFactory.getLog(JRBaseFiller.class);
    protected final Map<Integer, JRFillElement> fillElements = new HashMap<Integer, JRFillElement>();
    protected final int fillerId;
    protected JRBaseFiller parentFiller;
    protected JRFillSubreport parentElement;
    private final JRFillObjectFactory factory;
    private JRStyledTextParser styledTextParser = JRStyledTextParser.getInstance();
    private boolean isInterrupted;
    protected String name;
    protected int columnCount = 1;
    protected PrintOrderEnum printOrder = PrintOrderEnum.VERTICAL;
    protected RunDirectionEnum columnDirection = RunDirectionEnum.LTR;
    protected int pageWidth;
    protected int pageHeight;
    protected OrientationEnum orientation = OrientationEnum.PORTRAIT;
    protected WhenNoDataTypeEnum whenNoDataType = WhenNoDataTypeEnum.NO_PAGES;
    protected int columnWidth;
    protected int columnSpacing;
    protected int leftMargin;
    protected int rightMargin;
    protected int topMargin;
    protected int bottomMargin;
    protected boolean isTitleNewPage;
    protected boolean isSummaryNewPage;
    protected boolean isSummaryWithPageHeaderAndFooter;
    protected boolean isFloatColumnFooter;
    protected WhenResourceMissingTypeEnum whenResourceMissingType = WhenResourceMissingTypeEnum.NULL;
    protected JRFillReportTemplate[] reportTemplates;
    protected List<JRTemplate> templates;
    protected JRStyle defaultStyle;
    protected JRStyle[] styles;
    protected JRFillDataset mainDataset;
    protected JRFillGroup[] groups;
    protected JRFillSection missingFillSection;
    protected JRFillBand missingFillBand;
    protected JRFillBand background;
    protected JRFillBand title;
    protected JRFillBand pageHeader;
    protected JRFillBand columnHeader;
    protected JRFillSection detailSection;
    protected JRFillBand columnFooter;
    protected JRFillBand pageFooter;
    protected JRFillBand lastPageFooter;
    protected JRFillBand summary;
    protected JRFillBand noData;
    protected JRVirtualizationContext virtualizationContext;
    protected ElementEvaluationVirtualizationListener virtualizationListener;
    protected ClassLoader reportClassLoader;
    protected FormatFactory formatFactory;
    protected URLStreamHandlerFactory urlHandlerFactory;
    protected FileResolver fileResolver;
    protected JRFillContext fillContext;
    protected Map<JREvaluationTime, LinkedMap<Object, EvaluationBoundAction>> boundElements;
    protected JasperPrint jasperPrint;
    protected JRPrintPage printPage;
    protected int printPageStretchHeight;
    protected List<JRBand> bands;
    protected Map<Integer, JRBaseFiller> subfillers;
    private Thread fillingThread;
    protected JRCalculator calculator;
    protected JRAbstractScriptlet scriptlet;
    protected Map<String, JRFillDataset> datasetMap;
    protected JasperReport jasperReport;
    private boolean bandOverFlowAllowed;
    protected Map<String, Format> dateFormatCache = new HashMap<String, Format>();
    protected Map<String, Format> numberFormatCache = new HashMap<String, Format>();
    private JRSubreportRunner subreportRunner;
    protected SavePoint keepTogetherSavePoint;
    protected boolean isCreatingNewPage;
    protected boolean isNewPage;
    protected boolean isNewColumn;
    protected boolean isNewGroup = true;
    protected boolean isFirstPageBand;
    protected boolean isFirstColumnBand;
    protected int columnIndex;
    protected int offsetX;
    protected int offsetY;
    protected int columnHeaderOffsetY;
    protected int columnFooterOffsetY;
    protected int lastPageColumnFooterOffsetY;
    protected boolean isLastPageFooter;
    private final List<DefaultStyleListener> defaultStyleListeners = new ArrayList<DefaultStyleListener>();
    private static final JRStyleSetter DUMMY_STYLE_SETTER = new JRStyleSetter(){

        public void setStyle(JRStyle style) {
        }

        public void setStyleNameReference(String name) {
        }
    };

    protected JRBaseFiller(JasperReport jasperReport, JREvaluator initEvaluator, JRFillSubreport parentElement) throws JRException {
        this(jasperReport, (DatasetExpressionEvaluator)initEvaluator, parentElement);
    }

    protected JRBaseFiller(JasperReport jasperReport, DatasetExpressionEvaluator initEvaluator, JRFillSubreport parentElement) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.jasperReport = jasperReport;
        this.parentElement = parentElement;
        if (parentElement != null) {
            this.parentFiller = parentElement.filler;
        }
        this.fillContext = this.parentFiller == null ? new JRFillContext() : this.parentFiller.fillContext;
        this.fillerId = this.fillContext.generatedFillerId();
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": created for " + jasperReport.getName());
        }
        this.name = jasperReport.getName();
        this.columnCount = jasperReport.getColumnCount();
        this.printOrder = jasperReport.getPrintOrderValue();
        this.columnDirection = jasperReport.getColumnDirection();
        this.pageWidth = jasperReport.getPageWidth();
        this.pageHeight = jasperReport.getPageHeight();
        this.orientation = jasperReport.getOrientationValue();
        this.whenNoDataType = jasperReport.getWhenNoDataTypeValue();
        this.columnWidth = jasperReport.getColumnWidth();
        this.columnSpacing = jasperReport.getColumnSpacing();
        this.leftMargin = jasperReport.getLeftMargin();
        this.rightMargin = jasperReport.getRightMargin();
        this.topMargin = jasperReport.getTopMargin();
        this.bottomMargin = jasperReport.getBottomMargin();
        this.isTitleNewPage = jasperReport.isTitleNewPage();
        this.isSummaryNewPage = jasperReport.isSummaryNewPage();
        this.isSummaryWithPageHeaderAndFooter = jasperReport.isSummaryWithPageHeaderAndFooter();
        this.isFloatColumnFooter = jasperReport.isFloatColumnFooter();
        this.whenResourceMissingType = jasperReport.getWhenResourceMissingTypeValue();
        this.jasperPrint = new JasperPrint();
        JRProperties.transferProperties(jasperReport, (JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.print.transfer.");
        this.calculator = initEvaluator == null ? JRFillDataset.createCalculator(jasperReport, jasperReport.getMainDataset()) : new JRCalculator(initEvaluator);
        this.factory = new JRFillObjectFactory(this);
        this.missingFillBand = new JRFillBand(this, null, this.factory);
        this.missingFillSection = new JRFillSection(this, null, this.factory);
        this.createDatasets();
        this.mainDataset = this.factory.getDataset(jasperReport.getMainDataset());
        this.groups = this.mainDataset.groups;
        this.createReportTemplates(this.factory);
        String reportName = this.factory.getFiller().isSubreport() ? this.factory.getFiller().getJasperReport().getName() : null;
        this.background = this.factory.getBand(jasperReport.getBackground());
        if (this.background != this.missingFillBand) {
            this.background.setOrigin(new JROrigin(reportName, BandTypeEnum.BACKGROUND));
        }
        this.title = this.factory.getBand(jasperReport.getTitle());
        if (this.title != this.missingFillBand) {
            this.title.setOrigin(new JROrigin(reportName, BandTypeEnum.TITLE));
        }
        this.pageHeader = this.factory.getBand(jasperReport.getPageHeader());
        if (this.pageHeader != this.missingFillBand) {
            this.pageHeader.setOrigin(new JROrigin(reportName, BandTypeEnum.PAGE_HEADER));
        }
        this.columnHeader = this.factory.getBand(jasperReport.getColumnHeader());
        if (this.columnHeader != this.missingFillBand) {
            this.columnHeader.setOrigin(new JROrigin(reportName, BandTypeEnum.COLUMN_HEADER));
        }
        this.detailSection = this.factory.getSection(jasperReport.getDetailSection());
        if (this.detailSection != this.missingFillSection) {
            this.detailSection.setOrigin(new JROrigin(reportName, BandTypeEnum.DETAIL));
        }
        this.columnFooter = this.factory.getBand(jasperReport.getColumnFooter());
        if (this.columnFooter != this.missingFillBand) {
            this.columnFooter.setOrigin(new JROrigin(reportName, BandTypeEnum.COLUMN_FOOTER));
        }
        this.pageFooter = this.factory.getBand(jasperReport.getPageFooter());
        if (this.pageFooter != this.missingFillBand) {
            this.pageFooter.setOrigin(new JROrigin(reportName, BandTypeEnum.PAGE_FOOTER));
        }
        this.lastPageFooter = this.factory.getBand(jasperReport.getLastPageFooter());
        if (this.lastPageFooter != this.missingFillBand) {
            this.lastPageFooter.setOrigin(new JROrigin(reportName, BandTypeEnum.LAST_PAGE_FOOTER));
        }
        this.summary = this.factory.getBand(jasperReport.getSummary());
        if (this.summary != this.missingFillBand && this.summary.isEmpty()) {
            this.summary = this.missingFillBand;
        }
        if (this.summary != this.missingFillBand) {
            this.summary.setOrigin(new JROrigin(reportName, BandTypeEnum.SUMMARY));
        }
        this.noData = this.factory.getBand(jasperReport.getNoData());
        if (this.noData != this.missingFillBand) {
            this.noData.setOrigin(new JROrigin(reportName, BandTypeEnum.NO_DATA));
        }
        this.mainDataset.initElementDatasets(this.factory);
        this.initDatasets(this.factory);
        this.mainDataset.checkVariableCalculationReqs(this.factory);
        this.mainDataset.setCalculator(this.calculator);
        this.mainDataset.initCalculator();
        this.initBands();
    }

    protected Map<String, JRFillParameter> getParametersMap() {
        return this.mainDataset.parametersMap;
    }

    public Map<String, Object> getParameterValuesMap() {
        return this.mainDataset.getParameterValuesMap();
    }

    protected Map<String, JRFillField> getFieldsMap() {
        return this.mainDataset.fieldsMap;
    }

    protected Map<String, JRFillVariable> getVariablesMap() {
        return this.mainDataset.variablesMap;
    }

    protected JRFillVariable getVariable(String variableName) {
        return this.mainDataset.variablesMap.get(variableName);
    }

    protected JRFillField getField(String fieldName) {
        return this.mainDataset.getFillField(fieldName);
    }

    private void initBands() {
        this.bands = new ArrayList<JRBand>(8 + (this.groups == null ? 0 : 2 * this.groups.length));
        this.bands.add(this.title);
        this.bands.add(this.summary);
        this.bands.add(this.pageHeader);
        this.bands.add(this.pageFooter);
        this.bands.add(this.lastPageFooter);
        this.bands.add(this.columnHeader);
        this.bands.add(this.columnFooter);
        if (this.detailSection.getBands() != null) {
            this.bands.addAll(Arrays.asList(this.detailSection.getBands()));
        }
        this.bands.add(this.noData);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                if (group.getGroupHeaderSection().getBands() != null) {
                    this.bands.addAll(Arrays.asList(group.getGroupHeaderSection().getBands()));
                }
                if (group.getGroupFooterSection().getBands() == null) continue;
                this.bands.addAll(Arrays.asList(group.getGroupFooterSection().getBands()));
            }
        }
        this.initBandsNowEvaluationTimes();
    }

    private void initBandsNowEvaluationTimes() {
        JREvaluationTime[] groupEvaluationTimes;
        if (this.groups == null) {
            groupEvaluationTimes = new JREvaluationTime[]{};
        } else {
            int i;
            groupEvaluationTimes = new JREvaluationTime[this.groups.length];
            for (i = 0; i < this.groups.length; ++i) {
                groupEvaluationTimes[i] = JREvaluationTime.getGroupEvaluationTime(this.groups[i].getName());
            }
            for (i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                JRFillSection footer = (JRFillSection)group.getGroupFooterSection();
                for (int j = i; j < groupEvaluationTimes.length; ++j) {
                    footer.addNowEvaluationTime(groupEvaluationTimes[j]);
                }
            }
        }
        this.columnFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.summary.addNowEvaluationTimes(groupEvaluationTimes);
        this.noData.addNowEvaluationTimes(groupEvaluationTimes);
    }

    public JRStyledTextParser getStyledTextParser() {
        return this.styledTextParser;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public int getCurrentPageCount() {
        return this.getMasterFiller().jasperPrint.getPages().size();
    }

    @Override
    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    protected boolean isSubreport() {
        return this.parentFiller != null;
    }

    protected boolean isSubreportRunToBottom() {
        return this.parentElement != null && this.parentElement.isRunToBottom() != null && this.parentElement.isRunToBottom() != false;
    }

    protected boolean isInterrupted() {
        return this.isInterrupted || this.parentFiller != null && this.parentFiller.isInterrupted();
    }

    protected void setInterrupted(boolean isInterrupted) {
        this.isInterrupted = isInterrupted;
    }

    protected JRPrintPage getCurrentPage() {
        return this.printPage;
    }

    protected int getCurrentPageStretchHeight() {
        return this.printPageStretchHeight;
    }

    protected abstract void setPageHeight(int var1);

    public JasperPrint fill(Map<String, Object> parameterValues, Connection conn) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        this.setConnectionParameterValue(parameterValues, conn);
        return this.fill(parameterValues);
    }

    protected void setConnectionParameterValue(Map<String, Object> parameterValues, Connection conn) {
        this.mainDataset.setConnectionParameterValue(parameterValues, conn);
    }

    public JasperPrint fill(Map<String, Object> parameterValues, JRDataSource ds) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        this.setDatasourceParameterValue(parameterValues, ds);
        return this.fill(parameterValues);
    }

    protected void setDatasourceParameterValue(Map<String, Object> parameterValues, JRDataSource ds) {
        this.mainDataset.setDatasourceParameterValue(parameterValues, ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperPrint fill(Map<String, Object> parameterValues) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": filling report");
        }
        this.fillingThread = Thread.currentThread();
        RepositoryUtil.setRepositoryContext(new SimpleRepositoryContext(parameterValues));
        this.reportClassLoader = (ClassLoader)parameterValues.get("REPORT_CLASS_LOADER");
        this.urlHandlerFactory = (URLStreamHandlerFactory)parameterValues.get("REPORT_URL_HANDLER_FACTORY");
        this.fileResolver = (FileResolver)parameterValues.get("REPORT_FILE_RESOLVER");
        try {
            if (this.parentFiller != null) {
                this.parentFiller.registerSubfiller(this);
            }
            this.setParameters(parameterValues);
            this.loadStyles();
            this.jasperPrint.setName(this.name);
            this.jasperPrint.setPageWidth(this.pageWidth);
            this.jasperPrint.setPageHeight(this.pageHeight);
            this.jasperPrint.setTopMargin(this.topMargin);
            this.jasperPrint.setLeftMargin(this.leftMargin);
            this.jasperPrint.setBottomMargin(this.bottomMargin);
            this.jasperPrint.setRightMargin(this.rightMargin);
            this.jasperPrint.setOrientation(this.orientation);
            this.jasperPrint.setFormatFactoryClass(this.jasperReport.getFormatFactoryClass());
            this.jasperPrint.setLocaleCode(JRDataUtils.getLocaleCode(this.getLocale()));
            this.jasperPrint.setTimeZoneId(JRDataUtils.getTimeZoneId(this.getTimeZone()));
            this.jasperPrint.setDefaultStyle(this.defaultStyle);
            if (this.styles != null && this.styles.length > 0) {
                for (int i = 0; i < this.styles.length; ++i) {
                    this.addPrintStyle(this.styles[i]);
                }
            }
            this.createBoundElemementMaps();
            this.mainDataset.start();
            this.fillReport();
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": ended");
            }
            JasperPrint jasperPrint = this.jasperPrint;
            return jasperPrint;
        }
        finally {
            this.mainDataset.closeDatasource();
            if (this.parentFiller != null) {
                this.parentFiller.unregisterSubfiller(this);
            }
            if (this.fillContext.isUsingVirtualizer()) {
                this.virtualizationContext.removeListener(this.virtualizationListener);
            }
            this.fillingThread = null;
            this.killSubfillerThreads();
            RepositoryUtil.revertRepositoryContext();
        }
    }

    public void addPrintStyle(JRStyle style) throws JRException {
        this.jasperPrint.addStyle(style, true);
    }

    protected void addDefaultStyleListener(DefaultStyleListener listener) {
        this.defaultStyleListeners.add(listener);
    }

    protected void setDefaultStyle(JRStyle style) {
        this.defaultStyle = style;
        for (DefaultStyleListener listener : this.defaultStyleListeners) {
            listener.defaultStyleSet(style);
        }
    }

    protected void loadStyles() throws JRException {
        List<JRStyle> styleList = this.collectStyles();
        JRStyle reportDefaultStyle = this.jasperReport.getDefaultStyle();
        if (reportDefaultStyle == null) {
            this.lookupExternalDefaultStyle(styleList);
        }
        List<JRStyle> includedStyles = this.factory.setStyles(styleList);
        this.styles = includedStyles.toArray(new JRStyle[includedStyles.size()]);
        if (reportDefaultStyle != null) {
            this.setDefaultStyle(this.factory.getStyle(reportDefaultStyle));
        }
    }

    protected List<JRStyle> collectStyles() throws JRException {
        List<JRStyle> styleList = this.collectTemplateStyles();
        JRStyle[] reportStyles = this.jasperReport.getStyles();
        if (reportStyles != null) {
            this.styles = new JRStyle[reportStyles.length];
            for (int i = 0; i < reportStyles.length; ++i) {
                JRStyle style = reportStyles[i];
                styleList.add(style);
                this.factory.registerDelayedStyleSetter(DUMMY_STYLE_SETTER, style.getName());
            }
        }
        return styleList;
    }

    protected void collectTemplates() throws JRException {
        Collection paramTemplates;
        this.templates = new ArrayList<JRTemplate>();
        if (this.reportTemplates != null) {
            for (JRFillReportTemplate reportTemplate : this.reportTemplates) {
                JRTemplate template = reportTemplate.evaluate();
                if (template == null) continue;
                this.templates.add(template);
            }
        }
        if ((paramTemplates = (Collection)this.mainDataset.getParameterValue("REPORT_TEMPLATES", true)) != null) {
            this.templates.addAll(paramTemplates);
        }
    }

    public List<JRTemplate> getTemplates() {
        return this.templates;
    }

    protected List<JRStyle> collectTemplateStyles() throws JRException {
        this.collectTemplates();
        ArrayList<JRStyle> externalStyles = new ArrayList<JRStyle>();
        HashSet<String> loadedLocations = new HashSet<String>();
        for (JRTemplate template : this.templates) {
            this.collectStyles(template, externalStyles, loadedLocations);
        }
        return externalStyles;
    }

    protected void collectStyles(JRTemplate template, List<JRStyle> externalStyles, Set<String> loadedLocations) throws JRException {
        HashSet<String> parentLocations = new HashSet<String>();
        this.collectStyles(template, externalStyles, loadedLocations, parentLocations);
    }

    protected void collectStyles(JRTemplate template, List<JRStyle> externalStyles, Set<String> loadedLocations, Set<String> templateParentLocations) throws JRException {
        this.collectIncludedTemplates(template, externalStyles, loadedLocations, templateParentLocations);
        JRStyle[] templateStyles = template.getStyles();
        if (templateStyles != null) {
            for (int i = 0; i < templateStyles.length; ++i) {
                JRStyle style = templateStyles[i];
                String styleName = style.getName();
                if (styleName == null) {
                    throw new JRRuntimeException("External style name not set.");
                }
                externalStyles.add(style);
            }
        }
    }

    protected void collectIncludedTemplates(JRTemplate template, List<JRStyle> externalStyles, Set<String> loadedLocations, Set<String> templateParentLocations) throws JRException {
        JRTemplateReference[] includedTemplates = template.getIncludedTemplates();
        if (includedTemplates != null) {
            for (int i = 0; i < includedTemplates.length; ++i) {
                JRTemplateReference reference = includedTemplates[i];
                String location = reference.getLocation();
                if (!templateParentLocations.add(location)) {
                    throw new JRRuntimeException("Circular dependency found for template at location " + location);
                }
                if (!loadedLocations.add(location)) continue;
                JRTemplate includedTemplate = JRFillReportTemplate.loadTemplate(location, this.fillContext);
                this.collectStyles(includedTemplate, externalStyles, loadedLocations, templateParentLocations);
            }
        }
    }

    protected void lookupExternalDefaultStyle(Collection<JRStyle> styleList) {
        JRStyle defStyle = null;
        for (JRStyle style : styleList) {
            if (!style.isDefault()) continue;
            defStyle = style;
        }
        if (defStyle != null) {
            this.factory.registerDelayedStyleSetter(new JRStyleSetter(){

                public void setStyle(JRStyle style) {
                    if (style.isDefault()) {
                        JRBaseFiller.this.setDefaultStyle(style);
                    }
                }

                public void setStyleNameReference(String name) {
                }
            }, defStyle.getName());
        }
    }

    private void createBoundElemementMaps() {
        this.boundElements = new HashMap<JREvaluationTime, LinkedMap<Object, EvaluationBoundAction>>();
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_REPORT);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_COLUMN);
        if (this.groups != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.createBoundElementMaps(JREvaluationTime.getGroupEvaluationTime(this.groups[i].getName()));
            }
        }
        for (JRFillBand jRFillBand : this.bands) {
            this.createBoundElementMaps(JREvaluationTime.getBandEvaluationTime(jRFillBand));
        }
    }

    private void createBoundElementMaps(JREvaluationTime evaluationTime) {
        LinkedMap boundElementsMap = new LinkedMap();
        this.boundElements.put(evaluationTime, boundElementsMap);
    }

    private void killSubfillerThreads() {
        if (this.subfillers != null && !this.subfillers.isEmpty()) {
            for (JRBaseFiller subfiller : this.subfillers.values()) {
                if (subfiller.fillingThread == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Fill " + this.fillerId + ": Interrupting subfiller thread " + subfiller.fillingThread);
                }
                subfiller.fillingThread.interrupt();
            }
        }
    }

    protected abstract void fillReport() throws JRException;

    protected void setParameters(Map<String, Object> parameterValues) throws JRException {
        this.initVirtualizationContext(parameterValues);
        this.setFormatFactory(parameterValues);
        this.setIgnorePagination(parameterValues);
        this.mainDataset.setParameterValues(parameterValues);
        this.mainDataset.initDatasource();
        this.scriptlet = this.mainDataset.delegateScriptlet;
        if (!this.isSubreport()) {
            this.fillContext.setMasterFormatFactory(this.getFormatFactory());
            this.fillContext.setMasterLocale(this.getLocale());
            this.fillContext.setMasterTimeZone(this.getTimeZone());
        }
    }

    protected void initVirtualizationContext(Map<String, Object> parameterValues) {
        if (this.isSubreport()) {
            if (this.fillContext.isUsingVirtualizer()) {
                this.virtualizationContext = new JRVirtualizationContext(this.fillContext.getVirtualizationContext());
                this.setVirtualPageSize(parameterValues);
                this.virtualizationListener = new ElementEvaluationVirtualizationListener(this);
                this.virtualizationContext.addListener(this.virtualizationListener);
            }
        } else {
            JRVirtualizer virtualizer = (JRVirtualizer)parameterValues.get("REPORT_VIRTUALIZER");
            if (virtualizer == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": using virtualizer " + virtualizer);
            }
            this.fillContext.setUsingVirtualizer(true);
            this.virtualizationContext = this.fillContext.getVirtualizationContext();
            this.virtualizationContext.setVirtualizer(virtualizer);
            this.setVirtualPageSize(parameterValues);
            this.virtualizationListener = new ElementEvaluationVirtualizationListener(this);
            this.virtualizationContext.addListener(this.virtualizationListener);
            JRVirtualizationContext.register(this.virtualizationContext, this.jasperPrint);
        }
    }

    protected void setVirtualPageSize(Map<String, Object> parameterValues) {
        String pageSizeProp;
        Integer virtualPageSize = (Integer)parameterValues.get("net.sf.jasperreports.virtual.page.element.size");
        if (virtualPageSize == null && (pageSizeProp = this.jasperReport.getPropertiesMap().getProperty("net.sf.jasperreports.virtual.page.element.size")) != null) {
            virtualPageSize = JRProperties.asInteger(pageSizeProp);
        }
        if (virtualPageSize != null) {
            if (log.isDebugEnabled()) {
                log.debug("virtual page size " + virtualPageSize);
            }
            this.virtualizationContext.setPageElementSize(virtualPageSize);
        }
    }

    private void setFormatFactory(Map<String, Object> parameterValues) {
        this.formatFactory = (FormatFactory)parameterValues.get("REPORT_FORMAT_FACTORY");
        if (this.formatFactory == null) {
            this.formatFactory = DefaultFormatFactory.createFormatFactory(this.jasperReport.getFormatFactoryClass());
            parameterValues.put("REPORT_FORMAT_FACTORY", this.formatFactory);
        }
    }

    private void setIgnorePagination(Map<String, Object> parameterValues) {
        if (this.parentFiller == null) {
            Boolean isIgnorePaginationParam = (Boolean)parameterValues.get("IS_IGNORE_PAGINATION");
            if (isIgnorePaginationParam != null) {
                this.fillContext.setIgnorePagination(isIgnorePaginationParam);
            } else {
                boolean ignorePagination = this.jasperReport.isIgnorePagination();
                this.fillContext.setIgnorePagination(ignorePagination);
                parameterValues.put("IS_IGNORE_PAGINATION", ignorePagination ? Boolean.TRUE : Boolean.FALSE);
            }
        } else {
            boolean ignorePagination = this.fillContext.isIgnorePagination();
            parameterValues.put("IS_IGNORE_PAGINATION", ignorePagination ? Boolean.TRUE : Boolean.FALSE);
        }
        if (this.fillContext.isIgnorePagination()) {
            this.isTitleNewPage = false;
            this.isSummaryNewPage = false;
            if (this.groups != null) {
                for (int i = 0; i < this.groups.length; ++i) {
                    this.groups[i].setStartNewPage(false);
                    this.groups[i].setResetPageNumber(false);
                    this.groups[i].setStartNewColumn(false);
                }
            }
            this.setPageHeight(Integer.MAX_VALUE);
        }
    }

    protected Locale getLocale() {
        return this.mainDataset.getLocale();
    }

    protected TimeZone getTimeZone() {
        return this.mainDataset.timeZone;
    }

    protected ResourceBundle getResourceBundle() {
        return this.mainDataset.resourceBundle;
    }

    protected FormatFactory getFormatFactory() {
        return this.formatFactory;
    }

    protected Format getDateFormat(String pattern) {
        Locale lc = this.getLocale();
        TimeZone tz = this.getTimeZone();
        String key = pattern + "|" + JRDataUtils.getLocaleCode(lc) + "|" + JRDataUtils.getTimeZoneId(tz);
        Format format = this.dateFormatCache.get(key);
        if (format == null && (format = this.getFormatFactory().createDateFormat(pattern, lc, tz)) != null) {
            this.dateFormatCache.put(key, format);
        }
        return format;
    }

    protected Format getNumberFormat(String pattern) {
        Locale lc = this.getLocale();
        String key = pattern + "|" + JRDataUtils.getLocaleCode(lc);
        Format format = this.numberFormatCache.get(key);
        if (format == null && (format = this.getFormatFactory().createNumberFormat(pattern, lc)) != null) {
            this.numberFormatCache.put(key, format);
        }
        return format;
    }

    protected boolean hasMasterFormatFactory() {
        return !this.isSubreport() || this.getFormatFactory().getClass().getName().equals(this.fillContext.getMasterFormatFactory().getClass().getName());
    }

    protected boolean hasMasterLocale() {
        return !this.isSubreport() || this.getLocale().equals(this.fillContext.getMasterLocale());
    }

    protected boolean hasMasterTimeZone() {
        return !this.isSubreport() || this.getTimeZone().equals(this.fillContext.getMasterTimeZone());
    }

    protected void setParameter(String parameterName, Object value) throws JRException {
        this.mainDataset.setParameter(parameterName, value);
    }

    protected void setParameter(JRFillParameter parameter, Object value) throws JRException {
        this.mainDataset.setParameter(parameter, value);
    }

    protected boolean next() throws JRException {
        return this.mainDataset.next();
    }

    protected void resolveBoundElements(JREvaluationTime evaluationTime, byte evaluation) throws JRException {
        LinkedMap<Object, EvaluationBoundAction> boundElementsMap = this.boundElements.get(evaluationTime);
        while (!boundElementsMap.isEmpty()) {
            EvaluationBoundAction action = boundElementsMap.pop();
            action.execute(evaluation, evaluationTime);
        }
    }

    protected void resolveReportBoundElements() throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_REPORT, (byte)3);
    }

    protected void resolvePageBoundElements(byte evaluation) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_PAGE, evaluation);
    }

    protected void resolveColumnBoundElements(byte evaluation) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_COLUMN, evaluation);
    }

    protected void resolveGroupBoundElements(byte evaluation, boolean isFinal) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                if ((!group.hasChanged() || !group.isFooterPrinted()) && !isFinal) continue;
                String groupName = group.getName();
                this.resolveBoundElements(JREvaluationTime.getGroupEvaluationTime(groupName), evaluation);
            }
        }
    }

    protected JRPrintPage newPage() {
        Serializable page;
        if (this.fillContext.isUsingVirtualizer()) {
            JRVirtualPrintPage virtualPage = new JRVirtualPrintPage(this.jasperPrint, this.virtualizationContext);
            page = virtualPage;
        } else {
            page = new JRBasePrintPage();
        }
        return page;
    }

    public Object getVariableValue(String variableName) {
        return this.mainDataset.getVariableValue(variableName);
    }

    public Object getParameterValue(String parameterName) {
        return this.mainDataset.getParameterValue(parameterName);
    }

    protected void resolveBandBoundElements(JRFillBand band, byte evaluation) throws JRException {
        this.resolveBoundElements(JREvaluationTime.getBandEvaluationTime(band), evaluation);
    }

    protected void addVariableCalculationReq(String variableName, CalculationEnum calculation) {
        this.mainDataset.addVariableCalculationReq(variableName, calculation);
    }

    public void cancelFill() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": cancelling");
        }
        if (this.fillContext.cancelRunningQuery()) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": query cancelled");
            }
        } else {
            Thread t = this.fillingThread;
            if (t != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Fill " + this.fillerId + ": Interrupting thread " + t);
                }
                t.interrupt();
            }
        }
    }

    protected void registerSubfiller(JRBaseFiller subfiller) {
        if (this.subfillers == null) {
            this.subfillers = new HashMap<Integer, JRBaseFiller>();
        }
        this.subfillers.put(subfiller.fillerId, subfiller);
    }

    protected void unregisterSubfiller(JRBaseFiller subfiller) {
        if (this.subfillers != null) {
            this.subfillers.remove(subfiller.fillerId);
        }
    }

    protected void addPage(JRPrintPage page) {
        if (!this.isSubreport()) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": adding page " + (this.jasperPrint.getPages().size() + 1));
            }
            this.jasperPrint.addPage(page);
            this.fillContext.setPrintPage(page);
        }
    }

    protected Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.mainDataset.evaluateExpression(expression, evaluation);
    }

    protected JRFillExpressionEvaluator getExpressionEvaluator() {
        return this.calculator;
    }

    private void createDatasets() throws JRException {
        this.datasetMap = new HashMap<String, JRFillDataset>();
        JRDataset[] datasets = this.jasperReport.getDatasets();
        if (datasets != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                JRFillDataset fillDataset = this.factory.getDataset(datasets[i]);
                fillDataset.createCalculator(this.jasperReport);
                this.datasetMap.put(datasets[i].getName(), fillDataset);
            }
        }
    }

    private void initDatasets(JRFillObjectFactory factory) {
        for (JRFillDataset dataset : this.datasetMap.values()) {
            dataset.inheritFromMain();
            dataset.initElementDatasets(factory);
        }
    }

    protected WhenResourceMissingTypeEnum getWhenResourceMissingType() {
        return this.mainDataset.whenResourceMissingType;
    }

    public JasperReport getJasperReport() {
        return this.jasperReport;
    }

    protected boolean isBandOverFlowAllowed() {
        return this.bandOverFlowAllowed;
    }

    protected void setBandOverFlowAllowed(boolean splittableBand) {
        this.bandOverFlowAllowed = splittableBand;
    }

    protected int getMasterColumnCount() {
        JRBaseFiller filler = this.parentFiller;
        int colCount = 1;
        while (filler != null) {
            colCount *= filler.columnCount;
            filler = filler.parentFiller;
        }
        return colCount;
    }

    public JRBaseFiller getMasterFiller() {
        JRBaseFiller filler = this;
        while (filler.parentFiller != null) {
            filler = filler.parentFiller;
        }
        return filler;
    }

    public JRFillDataset getMainDataset() {
        return this.mainDataset;
    }

    protected void addBoundElement(JRFillElement element, JRPrintElement printElement, EvaluationTimeEnum evaluationType, String groupName, JRFillBand band) {
        JRFillGroup group = groupName == null ? null : this.getGroup(groupName);
        this.addBoundElement(element, printElement, evaluationType, group, band);
    }

    protected void addBoundElement(JRFillElement element, JRPrintElement printElement, EvaluationTimeEnum evaluationType, JRGroup group, JRFillBand band) {
        JREvaluationTime evaluationTime = JREvaluationTime.getEvaluationTime(evaluationType, group, band);
        this.addBoundElement(element, printElement, evaluationTime);
    }

    protected void addBoundElement(JRFillElement element, JRPrintElement printElement, JREvaluationTime evaluationTime) {
        if (log.isDebugEnabled()) {
            log.debug("Adding evaluation of " + printElement + " by " + element + " for evaluation " + evaluationTime);
        }
        LinkedMap<Object, EvaluationBoundAction> boundElementsMap = this.boundElements.get(evaluationTime);
        boundElementsMap.add(printElement, new ElementEvaluationAction(element, printElement));
    }

    protected JRFillGroup getGroup(String groupName) {
        JRFillGroup group = null;
        if (this.groups != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                if (!this.groups[i].getName().equals(groupName)) continue;
                group = this.groups[i];
                break;
            }
        }
        if (group == null) {
            throw new JRRuntimeException("No such group " + groupName);
        }
        return group;
    }

    protected void setSubreportRunner(JRSubreportRunner runner) {
        this.subreportRunner = runner;
    }

    protected void suspendSubreportRunner() throws JRException {
        if (this.subreportRunner == null) {
            throw new JRRuntimeException("No subreport runner set.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": suspeding subreport runner");
        }
        this.subreportRunner.suspend();
    }

    protected void createReportTemplates(JRFillObjectFactory factory) {
        JRReportTemplate[] templates = this.jasperReport.getTemplates();
        if (templates != null) {
            this.reportTemplates = new JRFillReportTemplate[templates.length];
            for (int i = 0; i < templates.length; ++i) {
                JRReportTemplate template = templates[i];
                this.reportTemplates[i] = factory.getReportTemplate(template);
            }
        }
    }

    protected SavePoint advanceSavePoint(SavePoint savePoint, SavePoint newSavePoint) {
        if (savePoint == null) {
            savePoint = newSavePoint;
        } else if (newSavePoint != null) {
            if (savePoint.page == newSavePoint.page && savePoint.columnIndex == newSavePoint.columnIndex) {
                savePoint.saveHeightOffset(newSavePoint.heightOffset);
            } else {
                savePoint.moveSavePointContent();
                savePoint = newSavePoint;
            }
        }
        return savePoint;
    }

    protected boolean moveKeepTogetherSavePointContent() {
        boolean moved = false;
        if (this.keepTogetherSavePoint != null) {
            if (this.keepTogetherSavePoint.page == this.getCurrentPage()) {
                if (!this.keepTogetherSavePoint.isNewColumn) {
                    this.keepTogetherSavePoint.addContent(this.printPage, this.columnSpacing + this.columnWidth, this.offsetY - this.keepTogetherSavePoint.startOffsetY);
                    this.offsetY = this.offsetY + this.keepTogetherSavePoint.endOffsetY - this.keepTogetherSavePoint.startOffsetY;
                    moved = true;
                }
            } else if (!this.keepTogetherSavePoint.isNewPage) {
                this.keepTogetherSavePoint.addContent(this.printPage, (this.columnIndex - this.keepTogetherSavePoint.columnIndex) * (this.columnSpacing + this.columnWidth), this.offsetY - this.keepTogetherSavePoint.startOffsetY);
                this.offsetY = this.offsetY + this.keepTogetherSavePoint.endOffsetY - this.keepTogetherSavePoint.startOffsetY;
                moved = true;
            }
            this.keepTogetherSavePoint = null;
        }
        return moved;
    }

    public JRFillContext getFillContext() {
        return this.fillContext;
    }

    protected int getFillerId() {
        return this.fillerId;
    }

    public int assignElementId(JRFillElement fillElement) {
        int id = this.getFillContext().generateFillElementId();
        this.fillElements.put(id, fillElement);
        return id;
    }

    protected static interface DefaultStyleListener {
        public void defaultStyleSet(JRStyle var1);
    }
}

