/*
 * Decompiled with CFR 0.152.
 */
package Procesos;

import Datos.beanGenerico;
import Datos.beanPartida;
import Datos.beanPartidaDetalle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class Importar
extends JFrame {
    private JLabel jLabel1 = new JLabel();
    private JPanel jPanel1 = new JPanel();
    private XYLayout xYLayout1 = new XYLayout();
    private JTextField archivo = new JTextField();
    private JButton jButton1 = new JButton();
    protected ArrayList<beanPartida> listaPartidas;
    protected ArrayList<beanPartidaDetalle> listaPartidaDetalle;
    private transient Connection conn;
    private JButton jButton2 = new JButton();
    private JProgressBar jProgressBar1 = new JProgressBar();
    private JComboBox<beanGenerico> empresa = new JComboBox();
    private JLabel jLabel2 = new JLabel();

    public Importar(Connection conn) {
        try {
            this.conn = conn;
            this.jbInit();
            this.setResizable(false);
            this.cargarEmpresas();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.centerFrame(this);
        this.getContentPane().setLayout(null);
        this.setSize(new Dimension(398, 222));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Importar.this.this_windowClosed(e);
            }
        });
        this.jLabel1.setText("Archivo a Procesar:");
        this.jLabel1.setFont(new Font("Tahoma", 0, 13));
        this.jPanel1.setBounds(new Rectangle(10, 10, 370, 95));
        this.jPanel1.setLayout(this.xYLayout1);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder(1));
        this.archivo.setFont(new Font("Tahoma", 0, 13));
        this.archivo.setEditable(false);
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Importar.this.jButton1_actionPerformed(e);
            }
        });
        this.jButton2.setText("Iniciar Carga");
        this.jButton2.setBounds(new Rectangle(10, 110, 370, 30));
        this.jButton2.setFont(new Font("Tahoma", 0, 13));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Importar.this.jButton2_actionPerformed(e);
            }
        });
        this.jProgressBar1.setBounds(new Rectangle(10, 145, 370, 35));
        this.jProgressBar1.setStringPainted(true);
        this.jProgressBar1.setFont(new Font("Tahoma", 0, 13));
        this.jPanel1.add((Component)this.jLabel2, new XYConstraints(3, 18, 60, 15));
        this.jPanel1.add(this.empresa, new XYConstraints(128, 13, 225, 20));
        this.jPanel1.add((Component)this.jButton1, new XYConstraints(333, 38, 20, 20));
        this.jPanel1.add((Component)this.archivo, new XYConstraints(128, 38, 205, 20));
        this.jPanel1.add((Component)this.jLabel1, new XYConstraints(3, 43, 140, 15));
        this.jProgressBar1.setForeground(new JTable().getSelectionBackground());
        this.jLabel2.setText("Empresa:");
        this.jLabel2.setFont(new Font("Tahoma", 0, 13));
        this.getContentPane().add((Component)this.jProgressBar1, null);
        this.getContentPane().add((Component)this.jButton2, null);
        this.getContentPane().add((Component)this.jPanel1, null);
    }

    public void cargarEmpresas() {
        String sql = "select * from aco_empresas where activo = 'A'";
        this.empresa.addItem(new beanGenerico("", " "));
        try {
            Statement stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                this.empresa.addItem(new beanGenerico(rs.getString("id_empresa"), rs.getString("nombre_empresa")));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage());
        }
    }

    public void cargarPartidasDesdeExcel() {
        int idPartida = 0;
        beanPartida partida = new beanPartida();
        beanPartidaDetalle partidaDetalle = new beanPartidaDetalle();
        this.listaPartidas = new ArrayList();
        this.listaPartidaDetalle = new ArrayList();
        try {
            int i;
            this.conn.setAutoCommit(false);
            POIFSFileSystem poiStream = new POIFSFileSystem(new FileInputStream(this.archivo.getText()));
            HSSFWorkbook wb = new HSSFWorkbook(poiStream);
            HSSFSheet sheet = wb.getSheetAt(0);
            int totalRows = sheet.getLastRowNum();
            System.out.println("total rows " + totalRows);
            System.out.println("total rows " + sheet.getLastRowNum());
            HSSFRow row = null;
            HSSFRow rowAux = null;
            row = sheet.getRow(0);
            String num = "0";
            for (i = 2; i < totalRows; ++i) {
                System.out.println(i);
                if (i == 1623) {
                    System.out.println();
                }
                if ((row = sheet.getRow(i)) == null || row.getCell(0) == null || row.getCell(0).getCellType() != 1) continue;
                if (row.getCell(0).getRichStringCellValue().toString().equalsIgnoreCase("FECHA")) {
                    partida = new beanPartida();
                    partida.setIdPartida(++idPartida);
                    partida.setFecha(row.getCell(1).toString());
                    partida.setTipo(row.getCell(3).toString());
                    num = row.getCell(6).toString();
                    partida.setNumero(Integer.parseInt(num.substring(0, num.length() - 2)));
                    rowAux = sheet.getRow(i + 1);
                    if (rowAux.getCell(0) != null) {
                        partida.setConcepto(1 == rowAux.getCell(0).getCellType() ? rowAux.getCell(0).toString().replaceAll("CONCEPTO", "").trim() : Double.toString(rowAux.getCell(0).getNumericCellValue()));
                    } else if (rowAux.getCell(1) != null) {
                        partida.setConcepto(1 == rowAux.getCell(1).getCellType() ? rowAux.getCell(1).toString().replaceAll("CONCEPTO", "").trim() : Double.toString(rowAux.getCell(1).getNumericCellValue()));
                    } else {
                        partida.setConcepto(1 == rowAux.getCell(2).getCellType() ? rowAux.getCell(2).toString().replaceAll("CONCEPTO", "").trim() : Double.toString(rowAux.getCell(2).getNumericCellValue()));
                    }
                    this.listaPartidas.add(partida);
                    i += 3;
                    continue;
                }
                System.out.println("entra al else");
                if (idPartida <= 0 || row.getCell(0) == null || !this.esCuenta(row.getCell(0).toString())) continue;
                partidaDetalle = new beanPartidaDetalle();
                partidaDetalle.setIdPartida(partida.getIdPartida());
                rowAux = sheet.getRow(i + 1);
                if (rowAux.getCell(0) != null) {
                    partidaDetalle.setCuentaContable(rowAux.getCell(0).toString().replaceAll("-", ""));
                } else {
                    partidaDetalle.setCuentaContable(rowAux.getCell(1).toString().replaceAll("-", ""));
                }
                System.out.println("Cuenta Contable: " + partidaDetalle.getCuentaContable());
                if (rowAux.getCell(3) != null) {
                    partidaDetalle.setDetalle(1 == rowAux.getCell(3).getCellType() ? rowAux.getCell(3).getRichStringCellValue().toString() : Double.toString(rowAux.getCell(3).getNumericCellValue()));
                } else {
                    partidaDetalle.setDetalle("");
                }
                String debe = "0.0";
                String haber = "0.0";
                if (rowAux.getCell(5) != null) {
                    debe = rowAux.getCell(5).toString();
                }
                if (rowAux.getCell(6) != null) {
                    haber = rowAux.getCell(6).toString();
                }
                System.out.println("Debe: " + debe);
                System.out.println("Haber: " + haber);
                partidaDetalle.setDebe(Double.parseDouble(debe.replaceAll(",", "")));
                partidaDetalle.setHaber(Double.parseDouble(haber.replaceAll(",", "")));
                rowAux = sheet.getRow(i + 2);
                if (rowAux != null) {
                    if (rowAux.getCell(1) != null) {
                        partidaDetalle.setConcepto(rowAux.getCell(1).toString());
                    } else if (rowAux.getCell(2) != null) {
                        partidaDetalle.setConcepto(rowAux.getCell(2).toString());
                    } else {
                        partidaDetalle.setConcepto("");
                    }
                }
                this.listaPartidaDetalle.add(partidaDetalle);
                ++i;
            }
            System.out.println(this.listaPartidas.size());
            System.out.println("Sale");
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setMaximum(this.listaPartidas.size());
            for (i = 0; i < this.listaPartidas.size(); ++i) {
                String sql = "";
                partida = this.listaPartidas.get(i);
                System.out.print("# " + partida.getNumero());
                System.out.print(" fecha: " + partida.getFecha());
                System.out.print(" tipo: " + partida.getTipo());
                System.out.print(" tipo: " + partida.getTipo());
                System.out.print(" Concepto: " + partida.getConcepto());
                System.out.println(sql);
                System.out.println(this.listaPartidaDetalle.size() + " tama\u00f1o hijos");
                this.jProgressBar1.setValue(i + 1);
            }
            JOptionPane.showMessageDialog(null, "Partida ingresada correctamente");
            Importar.COMMIT(this.conn);
        }
        catch (Exception e) {
            Importar.ROLLBACK(this.conn);
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public boolean esCuenta(String txt) {
        System.out.println("entra a la funcion");
        boolean flag = false;
        System.out.println(txt.substring(0, 1));
        try {
            int i = Integer.parseInt(txt.substring(0, 1));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void jButton1_actionPerformed(ActionEvent e) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Microsoft Excel 97-2003 (*.xls)";
                }

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.getName().toLowerCase().endsWith(".xls");
                }
            });
            fileChooser.showOpenDialog(this);
            File f = fileChooser.getSelectedFile();
            if (f == null) {
                return;
            }
            this.archivo.setText(f.getAbsolutePath());
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage());
        }
    }

    private void jButton2_actionPerformed(ActionEvent e) {
        if (this.archivo.getText().length() == 0) {
            JOptionPane.showMessageDialog(null, "Debe elegir un archivo");
            return;
        }
        iniciarCarga ic = new iniciarCarga();
        ic.start();
    }

    private void this_windowClosed(WindowEvent e) {
        System.exit(0);
    }

    public void ingresarPartida(beanPartida bean, ArrayList<beanPartidaDetalle> childs) throws SQLException {
        String idTipo = this.obtenerIdTipoPartida(bean.getTipo());
        System.out.println("Tipo: " + bean.getTipo() + " id: " + idTipo);
        String idEmpresa = "1";
        int len = bean.getFecha().length();
        String anio = "";
        String mes = "";
        String mesContable = this.cambiarFormatoFecha(bean.getFecha()).substring(0, 7);
        String idPartida = this.LoadMaxPartida(this.conn, idEmpresa, this.cambiarFormatoFecha(bean.getFecha()), idTipo);
        String sql = "INSERT INTO aco_partidas(ID_EMPRESA, ID_PARTIDA, MES_CONTABLE, ID_TIPO_PARTIDA, FECHA_DOCUMENTO, FECHA_INGRESO, CONCEPTO, NUM_DOCUMENTO)VALUES(" + ((beanGenerico)this.empresa.getSelectedItem()).getId() + ",'" + idPartida + "','" + mesContable + "','" + idTipo + "','" + this.cambiarFormatoFecha(bean.getFecha()) + "','" + this.obtenerFecha() + "','" + bean.getConcepto() + "','" + idPartida + "');";
        System.out.println(sql);
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate(sql);
        for (int i = 0; i < childs.size(); ++i) {
            beanPartidaDetalle partidaDetalle = childs.get(i);
            if (partidaDetalle.getIdPartida() != bean.getIdPartida()) continue;
            System.out.println("idPartida" + partidaDetalle.getIdPartida() + " : " + partidaDetalle.getCuentaContable());
            this.ingresarPartidaDetalle(((beanGenerico)this.empresa.getSelectedItem()).getId(), idPartida, mesContable, idTipo, partidaDetalle);
        }
    }

    public void ingresarPartidaDetalle(String idEmpresa, String idPartida, String mesContable, String idTipoPartida, beanPartidaDetalle bean) throws SQLException {
        if (!this.validarExisteCuenta(bean.getCuentaContable(), idEmpresa)) {
            throw new SQLException("La cuenta " + bean.getCuentaContable() + " no existe o no permite sumas");
        }
        String sql = "INSERT INTO aco_partidas_detalle(ID_EMPRESA, ID_PARTIDA, MES_CONTABLE, ID_TIPO_PARTIDA, ID_CUENTA, COMENTARIO, DEBE, HABER) VALUES(" + idEmpresa + ",'" + idPartida + "','" + mesContable + "','" + idTipoPartida + "','" + bean.getCuentaContable() + "','" + bean.getDetalle() + " " + bean.getConcepto() + "'," + bean.getDebe() + "," + bean.getHaber() + ");";
        System.out.println(sql);
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        System.out.println("sale detalle");
    }

    public boolean validarExisteCuenta(String cuenta, String idEmpresa) {
        boolean flag = false;
        String sql = "select count(id_cuenta) as suma from aco_cuentas \nwhere ID_CUENTA ='" + cuenta + "' AND " + "ID_EMPRESA =" + idEmpresa + " AND " + " ACTIVO ='A' AND PERMITIR_SUMA ='S' ; ";
        try {
            Statement stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt("suma") <= 0) continue;
                flag = true;
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
            System.out.println(ex.getMessage());
        }
        return flag;
    }

    public String cambiarFormatoFecha(String fecha) {
        String fechaN = "";
        SimpleDateFormat parseador = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat formateador = new SimpleDateFormat("yyyy/MM/dd");
        try {
            Date date = parseador.parse(fecha);
            fechaN = formateador.format(date);
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
        System.out.println(fechaN);
        return fechaN;
    }

    public String LoadMaxPartida(Connection conn, String idEmpresa, String fecha, String idTipoPartida) {
        try {
            Statement stmt = conn.createStatement();
            String sql = "Select max(CONVERT(mid(id_partida,LENGTH('" + idTipoPartida + "')+1),UNSIGNED)) + 1 as max from aco_partidas " + "where id_empresa = " + idEmpresa + " " + "and id_tipo_partida = '" + idTipoPartida + "' " + "and mid(mes_contable,1,7) = '" + fecha.substring(0, 7) + "'";
            System.out.println(sql);
            String MaxId = "";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                MaxId = rs.getString("max");
            }
            if (MaxId == null) {
                MaxId = "1";
            }
            if (MaxId.equals("")) {
                MaxId = "1";
            }
            rs.close();
            stmt.close();
            String string = idTipoPartida + this.RellenarCadena(MaxId, 3, "I", "0");
            return string;
        }
        catch (Exception e) {
            System.out.println(e);
            return "0";
        }
    }

    public String RellenarCadena(String Cadena, int Longitud, String Lado, String Relleno) {
        Longitud -= Cadena.length();
        for (int i = 0; i < Longitud; ++i) {
            Cadena = Lado.equals("I") ? Relleno + Cadena : Cadena + Relleno;
        }
        return Cadena;
    }

    public String obtenerFecha() {
        Date fecha = new Date(Calendar.getInstance().getTimeInMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        String fechaTexto = formatter.format(fecha);
        System.out.println(fechaTexto);
        return fechaTexto;
    }

    public String obtenerIdTipoPartida(String tipo) {
        String cad = "O";
        if ((tipo = tipo.replaceAll(" ", "")).length() <= 0) {
            return "O";
        }
        switch (tipo.toUpperCase()) {
            case "CAJA": {
                cad = "C";
                break;
            }
            case "CAJACHICA": {
                cad = "CC";
                break;
            }
            case "EGRESO": {
                cad = "E";
                break;
            }
            case "CHEQUE": {
                cad = "CH";
                break;
            }
            case "DIARIO": {
                cad = "D";
                break;
            }
            case "DIARIOSPATRONALES": {
                cad = "DP";
                break;
            }
            case "GASTOS": {
                cad = "G";
                break;
            }
            case "INGRESOS": {
                cad = "I";
                break;
            }
            case "REMESA": {
                cad = "R";
                break;
            }
            case "COMPRAS": {
                cad = "CM";
                break;
            }
            case "VENTAS": {
                cad = "V";
                break;
            }
            case "TRANSFERENCIA": {
                cad = "T";
                break;
            }
            default: {
                if (tipo.length() > 1) {
                    cad.substring(0, 1);
                    break;
                }
                cad = "O";
            }
        }
        return cad;
    }

    public void centerFrame(Frame frame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)frame.getWidth()) / 3.0);
        int y = (int)((dimension.getHeight() - (double)frame.getHeight()) / 3.0);
        frame.setLocation(x, y);
    }

    public static void COMMIT(Connection conn) {
        String sql = "COMMIT";
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (SQLException e1) {
            JOptionPane.showMessageDialog(null, e1.toString());
        }
    }

    public static void ROLLBACK(Connection conn) {
        String sql = "ROLLBACK";
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (SQLException e1) {
            JOptionPane.showMessageDialog(null, e1.toString());
        }
    }

    public class iniciarCarga
    extends Thread {
        @Override
        public void run() {
            System.out.println("Entra");
            Importar.this.jButton2.setEnabled(false);
            Importar.this.jButton1.setEnabled(false);
            try {
                Importar.this.cargarPartidasDesdeExcel();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
            Importar.this.jButton2.setEnabled(true);
            Importar.this.jButton1.setEnabled(true);
        }
    }
}

